/***
*** Copyright (c) 2002-2003 Matsushita Electric Industrial Co., Ltd.
*** All Rights Reserved.
***/

/*=============================================================================
*** $File       sd_api.h
*** $System     SDɥ饤 API
=============================================================================*/
#ifndef __SD_API_H__
#define __SD_API_H__

/***********************************
    إåե
***********************************/
/* LinuxХإå */
#include <linux/fs.h>
#include <linux/timer.h>
#include <asm/irq.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/time.h>
#include <linux/interrupt.h>
#include <asm/uaccess.h>
#include <linux/wait.h>
#include <linux/delay.h>	// for udelay,mdelay
#include <asm/io.h>	// for virt_to_bus

/* إåȼإå */
#include "sdapi_define.h"
#include "sdapi_struct.h"
#include "sdapi_command.h"

/***********************************
    API ץȥ
***********************************/
extern int SD_F_Open( void );
extern int SD_F_Close( int filp );
extern int SD_F_Read( int filp, void *pvBuf, ULONG ulBufsize, ULONG ulOffset, USHORT usArea, FS_INFO *info );
extern int SD_F_Write( int filp, void *pvBuf, ULONG ulBufsize, ULONG ulOffset, USHORT usArea, FS_INFO *info );
extern int SD_F_Ioctl(int filp, UINT32 unCmd, ULONG ulArg );

#endif /*__SD_API_H__*/

